clear; %removes all variables from the workspace

T=0.001;
Length = 100;
vt = zeros(Length,1);
v = zeros(Length,1);

vt = linspace(0,T,Length); % Generate t for v
v = 100*(exp(vt/T)-1); % Generate v(t)
v(Length/2:Length) = 0; % Generate v(t)

Tspan = [0 T]; % Solve from t=1 to t=5
IC = [0 0]; % y(t=0) = 0
[T Y] = ode45(@(t,y) approde(t,y,v,vt,T),Tspan,IC); % Solve ODE

plot(T, Y(:,1));
title('Plot of y as a function of time');
xlabel('Time'); ylabel('Y(t)');